MenuScores = copy_table(BaseView)
MenuScores.definition = "menu_scores"

function MenuScores:init()
    BaseView.init(self)
    
    if portal_build then
        self.shortcuts.online.enabled = false
    end
    

    local chart, partial

    partial = file_load_lua_table("layouts/menu_scores_score.lua")
    chart = top_scores:get_scores_for_adventure("klondike")
    if chart and #chart > 0 then
        self.shortcuts.no_scores.enabled = false
        for i = 1, 10 do
            if chart[i] then
                --partial.number.text = i.."."
                --partial.number.y = 100 + i * 32
                partial.name.text = chart[i].name
                partial.name.y = 130 + i * 32
                partial.score.text = chart[i].score
                partial.score.y = 130 + i * 32
                for k,v in pairs(partial) do
                    self:create_and_add_object(v, false)
                end
            end
        end
    end

    --partial = file_load_lua_table("layouts/menu_scores_score.lua")
    --partial.number.x = partial.number.x + 400
    partial.name.x = partial.name.x + 400
    partial.score.x = partial.score.x + 400
    chart = top_scores:get_scores_for_adventure("double_klondike")
    if chart and #chart > 0 then
        self.shortcuts.no_scores.enabled = false
        for i = 1, 10 do
            if chart[i] then
                --partial.number.text = i.."."
                --partial.number.y = 100 + i * 32
                partial.name.text = chart[i].name
                partial.name.y = 130 + i * 32
                partial.score.text = chart[i].score
                partial.score.y = 130 + i * 32
                for k,v in pairs(partial) do
                    self:create_and_add_object(v, false)
                end
            end
        end
    end

    self:sort_objects()
end

function MenuScores:website_button()
    net_open_web(top_scores_url)
end

function MenuScores:back_button()
    fw:change_view(MainMenu, nil, "blend")
end
